<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
$hostname   = "localhost";
$user       = "groupber_gaj";
$password   = "group_gaji24";
$database   = "groupber_payroll";
header('Content-Type: application/json');

// Koneksi ke database
$connect = mysqli_connect($hostname, $user, $password, $database);

// Cek koneksi
if (!$connect) {
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed']);
    exit;
}

// Ambil data dari POST
$tanggal_absensi = $_POST['tanggal_absensi'] ?? null;
$id_pegawai = $_POST['id_pegawai'] ?? null;
$Pulang_LatLong = $_POST['Pulang_LatLong'] ?? null;
$Pulang_Alamat = $_POST['Pulang_Alamat'] ?? null;
$Pulang_Img = $_POST['Pulang_Img'] ?? null;
$status_kehadiran = $_POST['status_kehadiran'] ?? null;
$jam_keluar = $_POST['jam_keluar'] ?? null;

// Validasi input
if (!$tanggal_absensi || !$id_pegawai || !$status_kehadiran || !$jam_keluar) {
    echo json_encode(['status' => 'error', 'message' => 'Missing required fields']);
    exit;
}

// Cek apakah data absensi sudah ada
$stmt = $connect->prepare("SELECT * FROM t_absensi WHERE tanggal_absensi = ? AND id_pegawai = ?");
$stmt->bind_param("ss", $tanggal_absensi, $id_pegawai);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    // Update data absen keluar
    $stmt_update = $connect->prepare("UPDATE t_absensi SET Pulang_LatLong = ?, Pulang_Alamat = ?, Pulang_Img = ?, status_kehadiran = ?, jam_keluar = ? WHERE tanggal_absensi = ? AND id_pegawai = ?");
    $stmt_update->bind_param("sssssss", $Pulang_LatLong, $Pulang_Alamat, $Pulang_Img, $status_kehadiran, $jam_keluar, $tanggal_absensi, $id_pegawai);

    if ($stmt_update->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Absen keluar berhasil']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update absensi']);
    }

    $stmt_update->close();
} else {
    echo json_encode(['status' => 'error', 'message' => 'Belum Absen Masuk']);
}

// Tutup koneksi
$stmt->close();
mysqli_close($connect);
?>