<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require '../../config.php';
header('Content-Type: application/json');

$connect = getDatabaseConnection();
if (!$connect) {
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed']);
    exit;
}

$tanggal_absensi = $_POST['tanggal_absensi'] ?? null;
$id_pegawai = $_POST['id_pegawai'] ?? null;
$Pulang_LatLong = $_POST['Pulang_LatLong'] ?? null;
$Pulang_Alamat = $_POST['Pulang_Alamat'] ?? null;
$status_kehadiran = $_POST['status_kehadiran'] ?? null;
$jam_keluar = $_POST['jam_keluar'] ?? null;
$validasi = isset($_POST['validasi']) && $_POST['validasi'] === 'true';

if (!$tanggal_absensi || !$id_pegawai || !$status_kehadiran || !$jam_keluar) {
    echo json_encode(['status' => 'error', 'message' => 'Missing required fields']);
    exit;
}

$Pulang_Img = null;
$filepath = 'foto/';
if (!is_dir($filepath)) {
    mkdir($filepath, 0755, true);
}
if (isset($_FILES['Pulang_Img'])) {
    $filename = time() . '_pulang.jpg';
    $fullpath = $filepath . $filename;

    if (move_uploaded_file($_FILES['Pulang_Img']['tmp_name'], $fullpath)) {
        $Pulang_Img = $filename;
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Gagal mengunggah gambar']);
        exit;
    }
}

$stmt = $connect->prepare("SELECT jam_masuk, jam_keluar FROM t_absensi WHERE tanggal_absensi = ? AND id_pegawai = ?");
$stmt->bind_param("ss", $tanggal_absensi, $id_pegawai);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode(['status' => 'error', 'message' => 'Maaf, Anda belum melakukan absen masuk']);
    exit;
}

$row = $result->fetch_assoc();
if (!empty($row['jam_keluar'])) {
    echo json_encode(['status' => 'error', 'message' => 'Maaf, Anda sudah melakukan absen pulang']);
    exit;
}

$jamMasuk = DateTime::createFromFormat('H:i:s', $row['jam_masuk']);

// Normalisasi format jam_keluar agar bisa diparsing
$jam_keluar = strlen($jam_keluar) === 5 ? $jam_keluar . ':00' : $jam_keluar;
$jamKeluar = DateTime::createFromFormat('H:i:s', $jam_keluar);
$kurangJamText = "";
$kekuranganJam = 0;

// Default jam kerja reguler
// Inisialisasi nilai default reguler (jam kerja 08:00 s/d 17:00)
$jamMulaiIdeal = DateTime::createFromFormat('H:i:s', '08:00:00');
$jamSelesaiIdeal = DateTime::createFromFormat('H:i:s', '17:00:00');
$isShift = false;

// Cek apakah pegawai memiliki shift khusus di hari tersebut
$cekShift = $connect->prepare("
    SELECT t.jam_mulai, t.jam_selesai 
    FROM t_shift_jadwal j 
    JOIN t_shift_tipe t ON j.id_shift_tipe = t.id_shift_tipe 
    WHERE j.id_pegawai = ? AND j.tanggal = ? 
    LIMIT 1
");
$cekShift->bind_param("ss", $id_pegawai, $tanggal_absensi);
$cekShift->execute();
$shiftResult = $cekShift->get_result();

// Jika ditemukan shift, override jam kerja ideal dengan jam shift
if ($shiftResult->num_rows > 0) {
    $shift = $shiftResult->fetch_assoc();

    // Parsing jam shift dari DB
    $tempMulai = DateTime::createFromFormat('H:i:s', $shift['jam_mulai']);
    $tempSelesai = DateTime::createFromFormat('H:i:s', $shift['jam_selesai']);

    if ($tempMulai && $tempSelesai) {
        $jamMulaiIdeal = $tempMulai;
        $jamSelesaiIdeal = $tempSelesai;
        $isShift = true;
    }
}
// Validasi jam masuk
// Hitung target jam kerja berdasarkan durasi ideal (shift atau reguler)
$durasiTarget = $jamMulaiIdeal->diff($jamSelesaiIdeal);
$targetJamKerja = round($durasiTarget->h + ($durasiTarget->i / 60), 2);

// Jika menggunakan shift dan keluar terlalu cepat tanpa validasi, tolak absen keluar

if ($jamKeluar < $jamSelesaiIdeal && !$validasi) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Absen keluar lebih awal dari jam seharusnya (' . $jamSelesaiIdeal->format('H:i') . '). Diperlukan validasi.'
    ]);
    exit;
}


// Gunakan jam keluar maksimal sampai jam selesai ideal (shift atau reguler)
$jamKeluarEfektif = $jamKeluar > $jamSelesaiIdeal ? $jamSelesaiIdeal : $jamKeluar;

// Hitung durasi kerja aktual
$durasiAktual = $jamMasuk->diff($jamKeluarEfektif);
$totalJamKerja = round($durasiAktual->h + ($durasiAktual->i / 60), 2);
$jam_kerja_text = sprintf("%d jam %d menit", $durasiAktual->h, $durasiAktual->i);


// Hitung kekurangan jam jika total aktual kurang dari target
if ($totalJamKerja < $targetJamKerja) {
    $selisihMenit = round(($targetJamKerja - $totalJamKerja) * 60);
    $kurangJamText = floor($selisihMenit / 60) . ' jam ' . ($selisihMenit % 60) . ' menit';
    $kekuranganJam = $selisihMenit;
}

$stmt_update = $connect->prepare("UPDATE t_absensi SET Pulang_LatLong = ?, Pulang_Alamat = ?, Pulang_Img = ?, status_kehadiran = ?, jam_keluar = ?, jam_kerja = ?, kurang_menit = ? WHERE tanggal_absensi = ? AND id_pegawai = ?");
$stmt_update->bind_param(
    "ssssssdss",
    $Pulang_LatLong,
    $Pulang_Alamat,
    $Pulang_Img,
    $status_kehadiran,
    $jam_keluar,
    $totalJamKerja,
    $kekuranganJam,
    $tanggal_absensi,
    $id_pegawai
);

if ($stmt_update->execute()) {
    echo json_encode([
        'status' => 'success',
        'message' => 'Selamat, Absen keluar berhasil',
        'filename' => $Pulang_Img,
        'jam_kerja' => $totalJamKerja,
        'jam_kerja_text' => $jam_kerja_text,
        'kurang_menit' => $kekuranganJam,
        'kurang_jam_text' => $kurangJamText,
        'is_shift' => $isShift,
        'jam_mulai_ideal' => $jamMulaiIdeal->format('H:i:s'),
        'jam_selesai_ideal' => $jamSelesaiIdeal->format('H:i:s'),
        'jam_keluar_efektif' => $jamKeluarEfektif->format('H:i:s'),
        'jam_keluar' => $jamKeluar->format('H:i:s'),
        'jam_masuk' => $jamMasuk->format('H:i:s'),
        'tanggal_absensi' => $tanggal_absensi
    ]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Maaf, Absen keluar belum berhasil']);
}

$stmt_update->close();
$stmt->close();
$cekShift->close();
$connect->close();
