<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require '../../config.php'; // Pastikan path menuju config file sesuai
header('Content-Type: application/json');

// Periksa apakah metode HTTP adalah POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

// Koneksi ke database
$connect = getDatabaseConnection();

// Periksa apakah ada file yang diunggah
$file = $_FILES['file'] ?? null;

// Ambil data dari POST (karena ada file, gunakan $_POST, bukan JSON)
$input = $_POST;

// Ambil data dari input atau beri nilai default null
$eid = $input['eid'] ?? null;
$ename = $input['ename'] ?? null;
$descr = $input['descr'] ?? null;
$fromdate = $input['fromdate'] ?? null;
$todate = $input['todate'] ?? null;

// Validasi input
if (!$eid || !$ename || !$descr || !$fromdate || !$todate) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Semua field wajib diisi',
        'received_input' => [
            'eid' => $eid ?? 'Tidak diterima',
            'ename' => $ename ?? 'Tidak diterima',
            'descr' => $descr ?? 'Tidak diterima',
            'fromdate' => $fromdate ?? 'Tidak diterima',
            'todate' => $todate ?? 'Tidak diterima',
        ],
    ]);
    exit;
}

// Jika deskripsi mengandung kata "sakit", maka file harus diunggah
if (stripos($descr, 'sakit') !== false) {
    if (!$file) {
        echo json_encode([
            'status' => 'error',
            'message' => 'File bukti wajib diunggah untuk izin yang mengandung kata "Sakit"',
            'debug' => $_FILES,
        ]);
        exit;
    }

    // Validasi tipe file (PDF atau gambar)
    $allowedTypes = ['image/jpeg', 'image/png', 'application/pdf'];
    $allowedExtensions = ['jpg', 'jpeg', 'png', 'pdf'];

    // Cek MIME type
    $actualType = mime_content_type($file['tmp_name']);
    $fileExtension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));

    if (!in_array($actualType, $allowedTypes) || !in_array($fileExtension, $allowedExtensions)) {
        echo json_encode([
            'status' => 'error',
            'message' => 'File harus berupa gambar (JPG/PNG) atau PDF',
            'actual_type' => $actualType,
            'file_extension' => $fileExtension,
        ]);
        exit;
    }

    // Pastikan direktori upload tersedia
    $uploadDir = 'file_izin/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    // Simpan file ke direktori uploads
    $fileName = time() . '_' . preg_replace('/[^a-zA-Z0-9\._-]/', '_', $file['name']);
    $uploadPath = $uploadDir . $fileName;

    if (!move_uploaded_file($file['tmp_name'], $uploadPath)) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Gagal memindahkan file ke direktori upload',
        ]);
        exit;
    }
}

// Periksa apakah pengajuan izin sudah ada
$query_check = "SELECT * FROM t_perizinan WHERE ename = ? AND fromdate = ?";
$stmt_check = $connect->prepare($query_check);
$stmt_check->bind_param("ss", $ename, $fromdate);
$stmt_check->execute();
$result_check = $stmt_check->get_result();

if ($result_check->num_rows > 0) {
    echo json_encode(['status' => 'error', 'message' => 'Data izin sudah ada']);
} else {
    // Masukkan data izin dengan status default 'Pending'
    $status = 'Pending';
    $filePath = isset($fileName) ? $fileName : null;
    $query_insert = "INSERT INTO t_perizinan (eid, ename, descr, fromdate, todate, status, file_path) 
                     VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt_insert = $connect->prepare($query_insert);
    $stmt_insert->bind_param("sssssss", $eid, $ename, $descr, $fromdate, $todate, $status, $filePath);

    if ($stmt_insert->execute()) {
        echo json_encode([
            'status' => 'success',
            'message' => 'Izin berhasil dikirim',
            'data' => [
                'eid' => $eid,
                'ename' => $ename,
                'descr' => $descr,
                'fromdate' => $fromdate,
                'todate' => $todate,
                'status' => $status,
                'file_path' => $filePath,
            ],
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Gagal mengirim izin',
            'error' => $stmt_insert->error,
        ]);
    }

    $stmt_insert->close();
}

// Tutup koneksi
$stmt_check->close();
mysqli_close($connect);
