<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require '../../config.php'; // Pastikan path menuju config file sesuai
header('Content-Type: application/json');

// Periksa apakah metode HTTP adalah POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

// Koneksi ke database
$connect = getDatabaseConnection();

// Ambil data dari JSON body
$request_body = file_get_contents('php://input');
$data = json_decode($request_body, true);

// Ambil data dari JSON
$id_pegawai = $data['id_pegawai'] ?? null;
$tgl_lembur = $data['tgl_lembur'] ?? null;
$jenis_lembur = $data['jenis_lembur'] ?? null;
$keterangan = $data['keterangan'] ?? null;

// Validasi input
if (!$id_pegawai || !$tgl_lembur || !$jenis_lembur || !$keterangan) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Semua field wajib diisi',
        'received_input' => [
            'id_pegawai' => $id_pegawai ?? 'Tidak diterima',
            'tgl_lembur' => $tgl_lembur ?? 'Tidak diterima',
            'jenis_lembur' => $jenis_lembur ?? 'Tidak diterima',
            'keterangan' => $keterangan ?? 'Tidak diterima',
        ],
    ]);
    exit;
}

// Cek apakah data pengajuan lembur sudah ada
$query_check = "SELECT * FROM t_pengajuan_lembur WHERE id_pegawai = ? AND tgl_lembur = ?";
$stmt_check = $connect->prepare($query_check);
$stmt_check->bind_param("is", $id_pegawai, $tgl_lembur);
$stmt_check->execute();
$result_check = $stmt_check->get_result();

if ($result_check->num_rows > 0) {
    echo json_encode(['status' => 'error', 'message' => 'Pengajuan lembur untuk tanggal ini sudah ada']);
} else {
    // Insert data pengajuan lembur baru
    $status = 'Pending';
    $query_insert = "INSERT INTO t_pengajuan_lembur (id_pegawai, tgl_lembur, jenis_lembur, keterangan, status) 
                     VALUES (?, ?, ?, ?, ?)";
    $stmt_insert = $connect->prepare($query_insert);
    $stmt_insert->bind_param("issss", $id_pegawai, $tgl_lembur, $jenis_lembur, $keterangan, $status);

    if ($stmt_insert->execute()) {
        echo json_encode([
            'status' => 'success',
            'message' => 'Pengajuan lembur berhasil ditambahkan',
            'data' => [
                'id_pengajuan' => $stmt_insert->insert_id,
                'id_pegawai' => $id_pegawai,
                'tgl_lembur' => $tgl_lembur,
                'jenis_lembur' => $jenis_lembur,
                'keterangan' => $keterangan,
                'status' => $status,
            ],
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Gagal menambahkan pengajuan lembur']);
    }

    $stmt_insert->close();
}

// Tutup koneksi
$stmt_check->close();
mysqli_close($connect);

?>