<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require '../../config.php';
header('Content-Type: application/json');

$connect = getDatabaseConnection();
$id_pegawai = $_GET['id_pegawai'] ?? null;
$bulan = $_GET['bulan'] ?? date('m');
$tahun = $_GET['tahun'] ?? date('Y');

if (!$id_pegawai) {
    echo json_encode(['status' => 'error', 'message' => 'id_pegawai wajib diisi']);
    exit;
}

$tanggalAwal = "$tahun-$bulan-01";
$tanggalAkhir = date("Y-m-t", strtotime($tanggalAwal));

// Ambil hari libur
$liburQuery = $connect->prepare("SELECT tgl_libur FROM groupber_payroll.t_hari_libur WHERE tgl_libur BETWEEN ? AND ?");
$liburQuery->bind_param("ss", $tanggalAwal, $tanggalAkhir);
$liburQuery->execute();
$resultLibur = $liburQuery->get_result();
$liburList = [];
while ($r = $resultLibur->fetch_assoc()) {
    $liburList[] = $r['tgl_libur'];
}

// Ambil shift (walau hari libur)
$shiftQuery = $connect->prepare("SELECT tanggal FROM t_shift_jadwal WHERE id_pegawai = ? AND tanggal BETWEEN ? AND ?");
$shiftQuery->bind_param("sss", $id_pegawai, $tanggalAwal, $tanggalAkhir);
$shiftQuery->execute();
$resultShift = $shiftQuery->get_result();
$shiftHari = [];
while ($s = $resultShift->fetch_assoc()) {
    $shiftHari[] = $s['tanggal'];
}

// Ambil absensi
$absenQuery = $connect->prepare("SELECT tanggal_absensi, jam_masuk, jam_keluar, is_late FROM t_absensi WHERE id_pegawai = ? AND tanggal_absensi BETWEEN ? AND ?");
$absenQuery->bind_param("sss", $id_pegawai, $tanggalAwal, $tanggalAkhir);
$absenQuery->execute();
$resultAbsen = $absenQuery->get_result();
$absenMap = [];
$jumlahTelat = 0;
while ($a = $resultAbsen->fetch_assoc()) {
    if (!empty($a['jam_masuk']) && !empty($a['jam_keluar'])) {
        $absenMap[$a['tanggal_absensi']] = true;
    }
    if ($a['is_late'] == 1) {
        $jumlahTelat++;
    }
}

// Ambil data izin
$izinQuery = $connect->prepare("SELECT fromdate, todate FROM t_perizinan WHERE eid = ? AND status = 'Accepted' AND (fromdate <= ? AND todate >= ?)");
$izinQuery->bind_param("sss", $id_pegawai, $tanggalAkhir, $tanggalAwal);
$izinQuery->execute();
$resultIzin = $izinQuery->get_result();
$izinList = [];
while ($i = $resultIzin->fetch_assoc()) {
    $start = new DateTime($i['fromdate']);
    $end = new DateTime($i['todate']);
    $periodIzin = new DatePeriod($start, new DateInterval('P1D'), $end->modify('+1 day'));
    foreach ($periodIzin as $izinDate) {
        $izinList[] = $izinDate->format('Y-m-d');
    }
}

// Hitung hari kerja
$periode = new DatePeriod(
    new DateTime($tanggalAwal),
    new DateInterval('P1D'),
    (new DateTime($tanggalAkhir))->modify('+1 day')
);

$totalHariKerja = 0;
$totalMasuk = 0;
$hariTidakMasukLewat = 0;
$tanggalHariIni = date('Y-m-d');

$listMasuk = [];
$listTidakMasuk = [];
$listLibur = $liburList;
$listShift = $shiftHari;
$listIzin = [];

foreach ($periode as $date) {
    $tanggal = $date->format('Y-m-d');
    $hariKe = (int)$date->format('N'); // 6 = Sabtu, 7 = Minggu
    $isWeekend = $hariKe >= 7;
    $isLibur = in_array($tanggal, $liburList);
    $adaShift = in_array($tanggal, $shiftHari);

    $hitungHariKerja = (!$isWeekend && !$isLibur) || $adaShift;
    if ($hitungHariKerja) $totalHariKerja++;

    if (isset($absenMap[$tanggal])) {
        $totalMasuk++;
        $listMasuk[] = $tanggal;
    } elseif ($tanggal < $tanggalHariIni && $hitungHariKerja) {
        if (in_array($tanggal, $izinList)) {
            $listIzin[] = $tanggal;
        } else {
            $hariTidakMasukLewat++;
            $listTidakMasuk[] = $tanggal;
        }
    }
}

echo json_encode([
    'status' => 'success',
    'message' => 'Data absensi berhasil diambil',
    'data' => [
        'id_pegawai' => $id_pegawai,
        'bulan' => $bulan,
        'nama_bulan' => date('F', mktime(0, 0, 0, $bulan, 10)),
        'tahun' => $tahun,
        'hari_kerja' => $totalHariKerja,
        'hari_masuk' => $totalMasuk,
        'hari_tidak_masuk' => $totalHariKerja - $totalMasuk - count($listIzin),
        'hari_tidak_masuk_lewat' => $hariTidakMasukLewat,
        'libur' => count($liburList),
        'shift' => count($shiftHari),
        'jumlah_telat' => $jumlahTelat,
        'jumlah_libur' => count($liburList),
        'jumlah_shift' => count($shiftHari),
        'jumlah_izin' => count($listIzin),
        'list_masuk' => $listMasuk,
        'list_tidak_masuk' => $listTidakMasuk,
        'list_libur' => $listLibur,
        'list_shift' => $listShift,
        'list_izin' => $listIzin
    ]
]);
