<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require '../../config.php';
header('Content-Type: application/json');

$connect = getDatabaseConnection();

$id_pegawai = $_GET['id_pegawai'] ?? null;
$bulan = $_GET['bulan'] ?? date('m');
$tahun = $_GET['tahun'] ?? date('Y');

if (!$id_pegawai) {
    echo json_encode(['status' => 'error', 'message' => 'id_pegawai wajib diisi']);
    exit;
}

$tanggalAwal = "$tahun-$bulan-01";
$tanggalAkhir = date("Y-m-t", strtotime($tanggalAwal));

// Ambil data keterlambatan
$query = $connect->prepare("SELECT tanggal_absensi, jam_masuk, jam_keluar FROM t_absensi WHERE id_pegawai = ? AND is_late = 1 AND tanggal_absensi BETWEEN ? AND ?");
$query->bind_param("sss", $id_pegawai, $tanggalAwal, $tanggalAkhir);
$query->execute();
$result = $query->get_result();

$telatList = [];

while ($row = $result->fetch_assoc()) {
    $telatList[] = [
        'tanggal' => $row['tanggal_absensi'],
        'jam_masuk' => $row['jam_masuk'],
        'jam_keluar' => $row['jam_keluar'],
    ];
}

echo json_encode([
    'status' => 'success',
    'message' => 'Daftar keterlambatan berhasil diambil',
    'data' => $telatList
]);
