<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require '../../config.php'; // Pastikan path menuju config file sesuai
header('Content-Type: application/json');

// Validasi metode HTTP
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

// Koneksi ke database
$connect = getDatabaseConnection();

// Ambil parameter dari URL
$id_pegawai = $_GET['id_pegawai'] ?? null;
$cuti_id = $_GET['cuti_id'] ?? null;

// Validasi input
if (!$id_pegawai) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Parameter id_pegawai wajib diisi',
    ]);
    exit;
}

$image_base_path = "https://groupberkat.com/api/absen/file_izin/";

// Jika `cuti_id` ada, ambil detail cuti
if ($cuti_id) {
    $query_detail = "SELECT * FROM t_perizinan WHERE id = ? AND eid = ?";
    $stmt_detail = $connect->prepare($query_detail);
    $stmt_detail->bind_param("ii", $cuti_id, $id_pegawai);
    $stmt_detail->execute();
    $result_detail = $stmt_detail->get_result();

    if ($result_detail->num_rows > 0) {
        $cuti_detail = $result_detail->fetch_assoc();
        echo json_encode([
            'status' => 'success',
            'message' => 'Detail cuti ditemukan',
            'data' => [
                'id' => $cuti_detail['id'],
                'ename' => $cuti_detail['ename'],
                'descr' => $cuti_detail['descr'],
                'fromdate' => $cuti_detail['fromdate'],
                'todate' => $cuti_detail['todate'],
                'status' => $cuti_detail['status'],
                'file_path' => $row['file_path'] ? trim($image_base_path . $row['file_path']) : null,
            ],
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Detail cuti tidak ditemukan']);
    }

    $stmt_detail->close();
    $connect->close();
    exit;
}

// Jika `cuti_id` tidak ada, ambil daftar cuti
$query_list = "SELECT * FROM t_perizinan WHERE eid = ? ORDER BY fromdate DESC";
$stmt_list = $connect->prepare($query_list);
$stmt_list->bind_param("i", $id_pegawai);
$stmt_list->execute();
$result_list = $stmt_list->get_result();

if ($result_list->num_rows > 0) {
    $cuti_list = [];
    while ($row = $result_list->fetch_assoc()) {
        $cuti_list[] = [
            'id' => $row['id'],
            'ename' => $row['ename'],
            'descr' => $row['descr'],
            'fromdate' => $row['fromdate'],
            'todate' => $row['todate'],
            'status' => $row['status'],
            'file_path' => $row['file_path'] ? trim($image_base_path . $row['file_path']) : null,
        ];
    }

    echo json_encode([
        'status' => 'success',
        'message' => 'Daftar cuti ditemukan',
        'data' => $cuti_list,
    ]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Tidak ada data cuti ditemukan']);
}

$stmt_list->close();
$connect->close();
