<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
require '../../config.php'; // Pastikan path menuju config file sesuai
header('Content-Type: application/json');

// Periksa apakah metode HTTP adalah POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

// Koneksi ke database
$connect = getDatabaseConnection();

// Ambil data dari POST
$id_pegawai = $_POST['id_pegawai'] ?? null;
$tanggal_lembur = $_POST['tanggal_lembur'] ?? null;
$hari = $_POST['hari'] ?? null;
$Pulang_Alamat = $_POST['Pulang_Alamat'] ?? null;
$jam_keluar_lembur = $_POST['jam_keluar_lembur'] ?? null;

// Validasi input
if (!$id_pegawai || !$tanggal_lembur || !$hari || !$Pulang_Alamat || !$jam_keluar_lembur) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Semua field wajib diisi',
        'received_input' => [
            'id_pegawai' => $id_pegawai ?? 'Tidak diterima',
            'tanggal_lembur' => $tanggal_lembur ?? 'Tidak diterima',
            'hari' => $hari ?? 'Tidak diterima',
            'Pulang_Alamat' => $Pulang_Alamat ?? 'Tidak diterima',
            'jam_keluar_lembur' => $jam_keluar_lembur ?? 'Tidak diterima',
        ],
    ]);
    exit;
}

// Direktori untuk menyimpan gambar
$upload_dir = 'foto/lembur/';
if (!is_dir($upload_dir)) {
    mkdir($upload_dir, 0755, true);
}

// Proses upload gambar
$Pulang_Img = null;
if (isset($_FILES['Pulang_Img'])) {
    $file_name = time() . '_lembur_pulang.jpg';
    $file_path = $upload_dir . $file_name;

    if (move_uploaded_file($_FILES['Pulang_Img']['tmp_name'], $file_path)) {
        $Pulang_Img = $file_name; // Simpan nama file ke database
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Gagal mengunggah gambar']);
        exit;
    }
}

// Cek apakah data lembur sudah ada
$query_check_existing = "SELECT hari, jam_keluar_lembur, Pulang_Alamat FROM t_lembur WHERE id_pegawai = ? AND tanggal_lembur = ?";
$stmt_check_existing = $connect->prepare($query_check_existing);
$stmt_check_existing->bind_param("is", $id_pegawai, $tanggal_lembur);
$stmt_check_existing->execute();
$result_existing = $stmt_check_existing->get_result();

if ($result_existing->num_rows > 0) {
    $row = $result_existing->fetch_assoc();

    // Cek apakah data sudah diisi
    if ($row['hari'] && $row['jam_keluar_lembur'] && $row['Pulang_Alamat']) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Data lembur sudah lengkap dan tidak dapat diperbarui lagi.',
        ]);
        $stmt_check_existing->close();
        mysqli_close($connect);
        exit;
    }

    // Ambil jam masuk lembur
    $query_check_jam_masuk = "SELECT jam_masuk_lembur FROM t_lembur WHERE id_pegawai = ? AND tanggal_lembur = ?";
    $stmt_check_jam_masuk = $connect->prepare($query_check_jam_masuk);
    $stmt_check_jam_masuk->bind_param("is", $id_pegawai, $tanggal_lembur);
    $stmt_check_jam_masuk->execute();
    $result_jam_masuk = $stmt_check_jam_masuk->get_result();
    $jam_masuk_lembur = $result_jam_masuk->fetch_assoc()['jam_masuk_lembur'];

    // Hitung total jam dengan penggenapan
    $total_jam = calculateRoundedHours($jam_masuk_lembur, $jam_keluar_lembur);

    // Hitung upah lembur
    $upah_lembur = $total_jam * 10000;

    // Update data lembur
    $query_update = "UPDATE t_lembur 
                     SET hari = ?, Pulang_Alamat = ?, Pulang_Img = ?, total_jam = ?, jam_keluar_lembur = ?, upah_lembur = ?
                     WHERE id_pegawai = ? AND tanggal_lembur = ?";
    $stmt_update = $connect->prepare($query_update);
    $stmt_update->bind_param("ssssssis", $hari, $Pulang_Alamat, $Pulang_Img, $total_jam, $jam_keluar_lembur, $upah_lembur, $id_pegawai, $tanggal_lembur);

  if ($stmt_update->execute()) {
    echo json_encode([
        'status' => 'success',
        'message' => 'Data lembur berhasil diperbarui',
        'data' => [
            'tanggal_lembur' => $tanggal_lembur,
            'hari' => $hari,
            'Pulang_Alamat' => $Pulang_Alamat,
            'Pulang_Img' => $Pulang_Img,
            'total_jam' => $total_jam,
            'jam_keluar_lembur' => $jam_keluar_lembur,
            'upah_lembur' => $upah_lembur,
        ],
    ]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Gagal memperbarui data lembur']);
}

    $stmt_update->close();
} else {
    echo json_encode(['status' => 'error', 'message' => 'Belum ada data lembur masuk untuk tanggal ini']);
}

$stmt_check_existing->close();
mysqli_close($connect);

// Fungsi untuk menghitung total jam dengan aturan penggenapan
function calculateRoundedHours($jam_masuk, $jam_keluar) {
    $masuk = strtotime($jam_masuk);
    $keluar = strtotime($jam_keluar);

    if ($keluar > $masuk) {
        $total_seconds = $keluar - $masuk;
        $total_minutes = $total_seconds / 60;
        $hours = floor($total_minutes / 60); // Jam penuh
        $remaining_minutes = $total_minutes % 60; // Sisa menit

        // Penggenapan menit
        if ($remaining_minutes >= 15) {
            $hours += 1; // Genapkan ke atas
        }

        return $hours;
    } else {
        return 0;
    }
}
?>