<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
require '../../config.php'; // Pastikan path menuju file konfigurasi database
header('Content-Type: application/json');

// Validasi metode HTTP
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

// Koneksi ke database
$connect = getDatabaseConnection();

// Ambil parameter dari URL
$tanggal_absensi = $_GET['tanggal_absensi'] ?? null;
$id_pegawai = $_GET['id_pegawai'] ?? null;

// Validasi input
if (!$tanggal_absensi || !$id_pegawai) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Parameter tanggal_absensi dan id_pegawai wajib diisi',
        'received_input' => [
            'tanggal_absensi' => $tanggal_absensi ?? 'Tidak diterima',
            'id_pegawai' => $id_pegawai ?? 'Tidak diterima',
        ],
    ]);
    exit;
}

// Query untuk memeriksa absensi
$query = "SELECT * FROM t_absensi WHERE tanggal_absensi = ? AND id_pegawai = ?";
$stmt = $connect->prepare($query);
$stmt->bind_param("si", $tanggal_absensi, $id_pegawai);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $data = $result->fetch_assoc();

    echo json_encode([
        'status' => 'success',
        'message' => 'Data absensi ditemukan',
        'data' => [
            'tanggal_absensi' => $data['tanggal_absensi'],
            'id_pegawai' => $data['id_pegawai'],
            'jam_masuk' => $data['jam_masuk'] ?? null, // Jika ada kolom tambahan
            'jam_keluar' => $data['jam_keluar'] ?? null, // Jika ada kolom tambahan
            'Masuk_LatLong' => $data['Masuk_LatLong'] ?? null, // Jika ada kolom tambahan
            'Masuk_Alamat' => $data['Masuk_Alamat'] ?? null, // Jika ada kolom tambahan
            'Pulang_LatLong' => $data['Pulang_LatLong'] ?? null, // Jika ada kolom tambahan
            'Pulang_Alamat' => $data['Pulang_Alamat'] ?? null, // Jika ada kolom tambahan
            'status_kehadiran' => $data['status_kehadiran'] ?? null, // Jika ada kolom tambahan
        ],
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Data absensi tidak ditemukan untuk tanggal tersebut',
    ]);
}

// Tutup koneksi
$stmt->close();
$connect->close();

?>