<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
require '../../config.php'; // Pastikan path menuju config file sesuai
header('Content-Type: application/json');

// Periksa apakah metode HTTP adalah GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

// Koneksi ke database
$connect = getDatabaseConnection();

// Ambil parameter (opsional)
$id_pegawai = isset($_GET['id_pegawai']) ? $_GET['id_pegawai'] : null;

if (!$id_pegawai) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Parameter id_pegawai diperlukan',
    ]);
    exit;
}

// Query untuk mengambil data pengajuan lembur
$query = "SELECT id_pengajuan, id_pegawai, tgl_lembur, jenis_lembur, keterangan, status 
          FROM t_pengajuan_lembur 
          WHERE id_pegawai = ?";
$stmt = $connect->prepare($query);
$stmt->bind_param("s", $id_pegawai);
$stmt->execute();
$result = $stmt->get_result();

$data = [];
while ($row = $result->fetch_assoc()) {
    $tgl_lembur = $row['tgl_lembur'];

    // Cek apakah ada absen lembur masuk pada tanggal tersebut
    $query_check_masuk = "SELECT jam_masuk_lembur FROM t_lembur WHERE id_pegawai = ? AND tanggal_lembur = ?";
    $stmt_check_masuk = $connect->prepare($query_check_masuk);
    $stmt_check_masuk->bind_param("ss", $id_pegawai, $tgl_lembur);
    $stmt_check_masuk->execute();
    $result_check_masuk = $stmt_check_masuk->get_result();
    $absen_masuk = $result_check_masuk->fetch_assoc();

    // Cek apakah ada absen lembur keluar pada tanggal tersebut
    $query_check_keluar = "SELECT jam_keluar_lembur FROM t_lembur WHERE id_pegawai = ? AND tanggal_lembur = ?";
    $stmt_check_keluar = $connect->prepare($query_check_keluar);
    $stmt_check_keluar->bind_param("ss", $id_pegawai, $tgl_lembur);
    $stmt_check_keluar->execute();
    $result_check_keluar = $stmt_check_keluar->get_result();
    $absen_keluar = $result_check_keluar->fetch_assoc();
     $jam_keluar = $absen_keluar['jam_keluar_lembur'] ?? null;
    $jam_keluar = $jam_keluar === "" ? null : $jam_keluar;

    $data[] = [
        'id_pengajuan' => $row['id_pengajuan'],
        'id_pegawai' => $row['id_pegawai'],
        'tgl_lembur' => $row['tgl_lembur'],
        'jenis_lembur' => $row['jenis_lembur'],
        'keterangan' => $row['keterangan'],
        'status' => $row['status'],
        'absen_masuk_lembur' => $absen_masuk ? true : false,
        'jam_masuk' => $absen_masuk['jam_masuk_lembur'] ?? null,
            'absen_keluar_lembur' => !is_null($jam_keluar), // True jika jam_keluar tidak null
        'jam_keluar' => $jam_keluar,
    ];
}

// Jika data ditemukan
if (!empty($data)) {
    echo json_encode([
        'status' => 'success',
        'message' => 'Daftar pengajuan lembur ditemukan',
        'data' => $data,
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Tidak ada data pengajuan lembur',
    ]);
}

// Tutup koneksi
$stmt->close();
$stmt_check_masuk->close();
$stmt_check_keluar->close();
mysqli_close($connect);

?>