<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
require '../../config.php'; // Pastikan path ke file konfigurasi database benar
header('Content-Type: application/json');

// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

// Validasi metode HTTP
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

// Ambil JSON body dari request
$input = json_decode(file_get_contents('php://input'), true);

// Ambil data dari JSON body
$priode_gajian = $input['priode_gajian'] ?? null;
$id_pegawai = $input['id_pegawai'] ?? null;

// Validasi input
if (!$priode_gajian || !$id_pegawai) {
    echo json_encode([
        'status' => 'error',
        'message' => 'priode_gajian dan id_pegawai wajib diisi',
        'received_input' => [
            'priode_gajian' => $priode_gajian ?? 'Tidak diterima',
            'id_pegawai' => $id_pegawai ?? 'Tidak diterima',
        ],
    ]);
    exit;
}

// Koneksi ke database
$connect = getDatabaseConnection();

// Query untuk mengambil data slip gaji berdasarkan priode_gajian dan id_pegawai
$query = "SELECT 
            t_pembayaran_gaji.*, 
            t_pegawai.nama_pegawai, 
            t_pegawai.nik, 
            t_pegawai.uang_makan, 
             t_pegawai.tunjangan_transport, 
              t_pegawai.uang_makan_lembur, 
            t_bagian.nama_bagian, 
            t_cabang.nama_cabang,
            t_rekening.no_rekening
          FROM t_pembayaran_gaji
          LEFT JOIN t_pegawai ON t_pembayaran_gaji.id_pegawai = t_pegawai.id_pegawai
          LEFT JOIN t_rekening ON t_rekening.id_pegawai = t_pegawai.id_pegawai
          LEFT JOIN t_bagian ON t_pegawai.id_bagian = t_bagian.id_bagian
          LEFT JOIN t_cabang ON t_pegawai.id_cabang = t_cabang.id_cabang
          WHERE t_pembayaran_gaji.priode_gajian = ? AND t_pembayaran_gaji.id_pegawai = ?";
$stmt = $connect->prepare($query);
$stmt->bind_param("si", $priode_gajian, $id_pegawai);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $dataRow = $result->fetch_assoc();
       // Query untuk menghitung total jam lembur
    $queryLembur = "SELECT SUM(total_jam) AS jumlah_jam 
                    FROM t_lembur 
                    WHERE id_pegawai = ? 
                    AND DATE_FORMAT(tanggal_lembur, '%Y-%m') = ?";
    $stmtLembur = $connect->prepare($queryLembur);
    $stmtLembur->bind_param("is", $id_pegawai, $priode_gajian);
    $stmtLembur->execute();
    $resultLembur = $stmtLembur->get_result();
    $dataLembur = $resultLembur->fetch_assoc();
    $jumlahJamLembur = $dataLembur['jumlah_jam'] ?? 0;

    // Perhitungan penerimaan
    $penerimaan = [
        [
            'keterangan' => 'Gaji Pokok',
            'jumlah' => (int) $dataRow['penerimaan_gaji']
        ],
        [
            'keterangan' => 'Tunjangan Jabatan',
            'jumlah' => (int) $dataRow['penerimaan_tunj_jabatan']
        ],
        [
            'keterangan' => 'Tunjangan Transport',
            'rincian' => "{$dataRow['tunjangan_transport']} x {$dataRow['jumlah_masuk']}",
            'jumlah' => (int) $dataRow['penerimaan_tunj_transport']
        ],
        [
            'keterangan' => 'Uang Makan',
            'rincian' => "{$dataRow['uang_makan']} x {$dataRow['jumlah_masuk']}",
            'jumlah' => (int) $dataRow['penerimaan_uang_makan']
        ],
     
        [
    'keterangan' => 'Uang Makan Lembur',
    'rincian' => $dataRow['uang_makan_lembur'] > 0
        ? "{$dataRow['uang_makan_lembur']} x " . ($dataRow['penerimaan_uang_makan_lembur'] / $dataRow['uang_makan_lembur'])
        : "0 x 0",
    'jumlah' => (int) $dataRow['penerimaan_uang_makan_lembur']
],
        [
            'keterangan' => 'Uang Pulsa',
            'jumlah' => (int) $dataRow['penerimaan_uang_pulsa']
        ],
        [
            'keterangan' => 'Uang Makan Luar Kota',
            'jumlah' => (int) $dataRow['penerimaan_uang_makan_luar_kota']
        ],
        [
            'keterangan' => 'Insentif Gudang',
            'jumlah' => (int) $dataRow['penerimaan_insentif_gudang']
        ],
[
    'keterangan' => 'Lembur',
    'rincian' => $jumlahJamLembur > 0 
        ? "{$jumlahJamLembur} jam x " . ($dataRow['penerimaan_lembur'] / $jumlahJamLembur) 
        : "0 jam x 0",
    'jumlah' => $jumlahJamLembur > 0 
        ? (int) $dataRow['penerimaan_lembur'] 
        : 0
],
    [
            'keterangan' => 'JHT BPJS (3.7% Perusahaan)',
            'jumlah' => (int) $dataRow['potongan_jht']
        ],
        [
            'keterangan' => 'JKK BPJS (0.24% Perusahaan)',
            'jumlah' => (int) $dataRow['potongan_jkk']
        ],
        [
            'keterangan' => 'JKM BPJS (0.3% Perusahaan)',
            'jumlah' => (int) $dataRow['potongan_jkm']
        ],
        [
             'keterangan' => 'THR',
             'jumlah' => (int) $dataRow['penerimaan_thr']
        ],
        [
            'keterangan' => 'Penerimaan Lainnya',
            'jumlah' => (int) $dataRow['penerimaan_lainnya']
        ],
        
    ];

    // Perhitungan potongan
    $potongan = [
        [
            'keterangan' => 'JHT BPJS (2% Karyawan)',
            'jumlah' => (int) $dataRow['potongan_jhttk']
        ],
        [
            'keterangan' => 'JHT BPJS (3.7% Perusahaan)',
            'jumlah' => (int) $dataRow['potongan_jht']
        ],
        [
            'keterangan' => 'JKK BPJS (0.24% Perusahaan)',
            'jumlah' => (int) $dataRow['potongan_jkk']
        ],
        [
            'keterangan' => 'JKM BPJS (0.3% Perusahaan)',
            'jumlah' => (int) $dataRow['potongan_jkm']
        ],
        [
            'keterangan' => 'PPH21',
            'jumlah' => (int) $dataRow['potongan_pajak']
        ],
        [
            'keterangan' => 'Pembayaran Pinjaman',
            'jumlah' => (int) $dataRow['potongan_pinjaman']
        ],
        [
            'keterangan' => 'Potongan Lainnya',
            'jumlah' => (int) $dataRow['potongan_lainnya']
        ]
    ];

    // Total penerimaan dan potongan
    $total_penerimaan = array_sum(array_column($penerimaan, 'jumlah'));
    $total_potongan = array_sum(array_column($potongan, 'jumlah'));
    $gaji_diterima = $total_penerimaan - $total_potongan;

    // Response JSON
    echo json_encode([
        'status' => 'success',
        'message' => 'Data slip gaji ditemukan',
        'data' => [
            'periode_gajian' => $dataRow['priode_gajian'],
            'status_gaji' => $dataRow['status_gaji'],
            'jumlah_masuk' => $dataRow['jumlah_masuk'],
            'jumlah_hari' => $dataRow['jumlah_hari'],
            'status_pajak' => $dataRow['status_pajak'],
            'tanggal_gajian' => $dataRow['tanggal_gajian'],
            'pegawai' => [
                'nik' => $dataRow['nik'],
                'nama' => $dataRow['nama_pegawai'],
                'bagian' => $dataRow['nama_bagian'],
                'cabang' => $dataRow['nama_cabang'],
                'rekening' => $dataRow['nomor_rekening']
            ],
            'rincian' => [
                'penerimaan' => $penerimaan,
                'total_penerimaan' => $total_penerimaan,
                'potongan' => $potongan,
                'total_potongan' => $total_potongan,
                'gaji_diterima' => $gaji_diterima
            ]
        ]
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Data slip gaji tidak ditemukan'
    ]);
}

// Tutup koneksi
$stmt->close();
$connect->close();
?>