<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
require '../../config.php'; // Pastikan path ke file konfigurasi database benar
header('Content-Type: application/json');

// Validasi metode HTTP
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

// Ambil JSON body dari request
$input = json_decode(file_get_contents('php://input'), true);

// Ambil data dari JSON body
$priode_gajian = $input['priode_gajian'] ?? null;
$id_pegawai = $input['id_pegawai'] ?? null;

// Validasi input
if (!$priode_gajian || !$id_pegawai) {
    echo json_encode([
        'status' => 'error',
        'message' => 'priode_gajian dan id_pegawai wajib diisi',
        'received_input' => [
            'priode_gajian' => $priode_gajian ?? 'Tidak diterima',
            'id_pegawai' => $id_pegawai ?? 'Tidak diterima',
        ],
    ]);
    exit;
}

// Koneksi ke database
$connect = getDatabaseConnection();

// Query untuk mengambil data gaji
$query = "SELECT * FROM t_pembayaran_gaji WHERE priode_gajian = ? AND id_pegawai = ?";
$stmt = $connect->prepare($query);
$stmt->bind_param("ss", $priode_gajian, $id_pegawai);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $data = $result->fetch_assoc();

    // Response data gaji
    echo json_encode([
        'status' => 'success',
        'message' => 'Data gaji ditemukan',
        'data' => [
            'tanggal_gajian' => $data['tanggal_gajian'] ?? null,
            'status_pajak' => $data['status_pajak'] ?? null,
            'penerimaan_gaji' => $data['penerimaan_gaji'] ?? null,
            'penerimaan_tunj_jabatan' => $data['penerimaan_tunj_jabatan'] ?? null,
            'penerimaan_tunj_transport' => $data['penerimaan_tunj_transport'] ?? null,
            'penerimaan_uang_makan' => $data['penerimaan_uang_makan'] ?? null,
            'penerimaan_uang_makan_lembur' => $data['penerimaan_uang_makan_lembur'] ?? null,
            'penerimaan_uang_pulsa' => $data['penerimaan_uang_pulsa'] ?? null,
            'penerimaan_uang_makan_luar_kota' => $data['penerimaan_uang_makan_luar_kota'] ?? null,
            'penerimaan_insentif_gudang' => $data['penerimaan_insentif_gudang'] ?? null,
            'penerimaan_lembur' => $data['penerimaan_lembur'] ?? null,
            'penerimaan_lainnya' => $data['penerimaan_lainnya'] ?? null,
            'penerimaan_thr' => $data['penerimaan_thr'] ?? null, // <--- Tambahan ini
            'penerimaan_jhttk' => $data['penerimaan_jhttk'] ?? null,
            'potongan_pajak' => $data['potongan_pajak'] ?? null,
            'potongan_pinjaman' => $data['potongan_pinjaman'] ?? null,
            'potongan_jabatan' => $data['potongan_jabatan'] ?? null,
            'total_potongan' => $data['total_potongan'] ?? null,
            'potongan_lainnya' => $data['potongan_lainnya'] ?? null,
            'total_gaji_diterima' => $data['total_gaji_diterima'] ?? null,
            'status_gaji' => $data['status_gaji'] ?? null,
            'jumlah_hari' => $data['jumlah_hari'] ?? null,
        ]
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Data gaji belum tersedia untuk periode ini',
    ]);
}

// Tutup koneksi
$stmt->close();
$connect->close();
?>