<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");

require '../config.php'; // Pastikan path menuju file konfigurasi database
header('Content-Type: application/json');

// Validasi metode HTTP
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

// Koneksi ke database
$connect = getDatabaseConnection();

// Query untuk mengambil konfigurasi terbaru
$query = "SELECT * FROM api_config ORDER BY created_at DESC LIMIT 1";
$result = $connect->query($query);

// Periksa apakah ada data
if ($result && $result->num_rows > 0) {
    $config = $result->fetch_assoc();

    echo json_encode([
        'status' => 'success',
        'data' => [
            'version' => $config['version'],
            'update_android_url' => $config['update_android_url'],
            'update_apple_url' => $config['update_apple_url'],
            'image_update' => $config['image_update'],
            'maintenance' => (bool)$config['maintenance'],
            'api_base_url' => $config['api_base_url'],
            'update' => [
                'force_update' => (bool)$config['force_update'],
                'update_url' => $config['update_url'],
                'update_message' => $config['update_message']
            ],
            'working_hours' => [
                'start' => $config['working_hours_start'],
                'end' => $config['working_hours_end'],
                'lunch_break' => [
                    'start' => $config['lunch_break_start'],
                    'end' => $config['lunch_break_end']
                ]
            ],
            'public_holidays' => json_decode($config['public_holidays'], true),
            'leave_policies' => json_decode($config['leave_policies'], true),
            'timezone' => $config['timezone'],
            'notifications' => json_decode($config['notifications'], true),
            'geofences' => json_decode($config['geofences'], true),
            'emergency_contacts' => json_decode($config['emergency_contacts'], true),
            'languages' => json_decode($config['languages'], true),
            'attendance_policies' => json_decode($config['attendance_policies'], true),
            'announcements' => json_decode($config['announcements'], true),
            'role_absence'=> json_decode($config['role_absence'], true)
        ]
    ]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'No configuration found']);
}

// Tutup koneksi
$connect->close();

?>