<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
require '../../config.php'; // Naik dua level dari folder `api/auth/` ke `public_html`

// Koneksi ke database
$connect = getDatabaseConnection();

// Ambil data dari parameter GET
$id_pegawai = $_GET['id_pegawai'] ?? null;

// Validasi input
if (!$id_pegawai) {
    echo json_encode(['status' => 'error', 'message' => 'ID Pegawai wajib diisi']);
    exit;
}

// Query untuk mendapatkan data user, jabatan, dan cabang berdasarkan ID Pegawai
$stmt = $connect->prepare("
    SELECT 
        p.id_pegawai,
        p.nik,
        p.no_ktp,
        p.no_npwp,
        p.nama_pegawai,
        p.tempat_lahir,
        p.tanggal_lahir,
        p.alamat_pegawai,
        p.telp_pegawai,
        p.jenis_kelamin,
        p.agama,
        p.email_pegawai,
        p.pendidikan,
        p.status_perkawinan,
        p.jumlah_anak,
        p.id_jabatan,
        p.id_bagian,
        p.id_cabang,
        p.status_shift,
        p.tanggal_masuk,
        p.tanggal_berakhir,
        p.status_pegawai,
        p.photo_pegawai,
        p.pembayaran_gajian,
        p.status_kerja,
        p.kode_finger,
        p.norek_pegawai,
        p.gaji_pokok,
        p.uang_makan,
        p.tunjangan_transport,
        p.tunjangan_jht,
        p.tunjangan_jkk,
        p.tunjangan_jkm,
        p.uang_makan_lembur,
        p.uang_makan_luar_kota,
        p.tunjangan_jabatan,
        p.insentif_gudang,
        p.uang_pulsa,
        p.no_kk_pegawai,
        p.sub_department,
        p.nama_ibu,
        p.kontak_darurat,
        p.id_instansi,
        p.Pass_Login,
        j.nama_jabatan, -- Ambil nama jabatan dari tabel t_jabatan
        c.nama_cabang -- Ambil nama cabang dari tabel t_cabang
    FROM t_pegawai AS p
    LEFT JOIN t_jabatan AS j ON p.id_jabatan = j.id_jabatan
    LEFT JOIN t_cabang AS c ON p.id_cabang = c.id_cabang
    WHERE p.id_pegawai = ?
");
$stmt->bind_param("i", $id_pegawai);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $user = $result->fetch_assoc();
        // Atur singkatan untuk nama cabang menggunakan if-else
    if (trim($user['nama_cabang']) === 'CV. BERKAT MAKMUR SEJAHTERA') {
        $user['nama_cabang'] = 'BMS';
    } elseif (trim($user['nama_cabang']) === 'PT. APOTEK BERKAT NUSANTARA PURNAMA ') {
        $user['nama_cabang'] = 'ABNP';
    }elseif (trim($user['nama_cabang']) === 'PT.APOTEK BERKAT NUSANTARA KOTABARU') {
        $user['nama_cabang'] = 'ABNK';
    } elseif (trim($user['nama_cabang']) === 'PT. BERKAT JAYA PHARMA') {
        $user['nama_cabang'] = 'BJP';
    }
    echo json_encode([
        'status' => 'success',
        'message' => 'Data user ditemukan',
        'data' => $user
    ]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Data user tidak ditemukan']);
}

// Tutup koneksi
$stmt->close();
mysqli_close($connect);
?>