<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
require '../../config.php'; // Naik dua level dari folder `api/auth/` ke `public_html`

header('Content-Type: application/json');

// Periksa apakah metode HTTP adalah PUT
if ($_SERVER['REQUEST_METHOD'] !== 'PUT') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

// Ambil data JSON input dari `php://input`
$raw_input = file_get_contents('php://input');
$input = json_decode($raw_input, true);

// Debug jika JSON tidak valid
if (!$input) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid JSON format',
        'raw_input' => $raw_input
    ]);
    exit;
}

// Ambil data dari JSON input
$id_pegawai = $input['id_pegawai'] ?? null;
$nama_pegawai = $input['nama_pegawai'] ?? null;
$email_pegawai = $input['email_pegawai'] ?? null;
$telp_pegawai = $input['telp_pegawai'] ?? null;
$alamat_pegawai = $input['alamat_pegawai'] ?? null;

// Validasi input
if (!$id_pegawai) {
    echo json_encode(['status' => 'error', 'message' => 'ID Pegawai wajib diisi']);
    exit;
}
if (!$nama_pegawai || !$email_pegawai || !$telp_pegawai || !$alamat_pegawai) {
    echo json_encode(['status' => 'error', 'message' => 'Semua field wajib diisi']);
    exit;
}

// Validasi format email
if (!filter_var($email_pegawai, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(['status' => 'error', 'message' => 'Format email tidak valid']);
    exit;
}

// Koneksi ke database
$connect = getDatabaseConnection();
if (!$connect) {
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed']);
    exit;
}

// Cek apakah data user dengan ID Pegawai ada
$stmt_check = $connect->prepare("SELECT * FROM t_pegawai WHERE id_pegawai = ?");
$stmt_check->bind_param("i", $id_pegawai);
$stmt_check->execute();
$result_check = $stmt_check->get_result();

if ($result_check->num_rows > 0) {
    $old_data = $result_check->fetch_assoc();

    // Cek perubahan data
    $changes = [];
    if ($nama_pegawai !== $old_data['nama_pegawai']) {
        $changes[] = 'Nama berhasil diperbarui';
    }
    if ($email_pegawai !== $old_data['email_pegawai']) {
        $changes[] = 'Email berhasil diperbarui';
    }
    if ($telp_pegawai !== $old_data['telp_pegawai']) {
        $changes[] = 'Telepon berhasil diperbarui';
    }
    if ($alamat_pegawai !== $old_data['alamat_pegawai']) {
        $changes[] = 'Alamat berhasil diperbarui';
    }

    if (!empty($changes)) {
        // Update data user
        $stmt_update = $connect->prepare("
            UPDATE t_pegawai
            SET 
                nama_pegawai = ?, 
                email_pegawai = ?, 
                telp_pegawai = ?, 
                alamat_pegawai = ?
            WHERE id_pegawai = ?
        ");
        $stmt_update->bind_param("ssssi", $nama_pegawai, $email_pegawai, $telp_pegawai, $alamat_pegawai, $id_pegawai);

        if ($stmt_update->execute()) {
            // Jika lebih dari satu data diperbarui, tampilkan "Data berhasil diperbarui"
            if (count($changes) > 1) {
                echo json_encode([
                    'status' => 'success',
                    'message' => 'Data berhasil diperbarui'
                ]);
            } else {
                // Jika hanya satu data diperbarui, tampilkan pesan spesifik
                echo json_encode([
                    'status' => 'success',
                    'message' => $changes[0]
                ]);
            }
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Gagal memperbarui data']);
        }
        $stmt_update->close();
    } else {
        echo json_encode(['status' => 'info', 'message' => 'Tidak ada perubahan pada data']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Data user tidak ditemukan']);
}

// Tutup koneksi
$stmt_check->close();
mysqli_close($connect);
?>