<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
require '../../config.php'; // Naik dua level dari folder `api/auth/` ke `public_html`

header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Koneksi ke database
$connect = getDatabaseConnection();
if (!$connect) {
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed']);
    exit;
}

// Menambahkan lokasi
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add') {
    $name = $_POST['name'] ?? null;
    $lat = $_POST['lat'] ?? null;
    $lng = $_POST['lng'] ?? null;
    $color = $_POST['color'] ?? null;
    $radius = $_POST['radius'] ?? null;
    $code = $_POST['code'] ?? null;
    $active = $_POST['active'] ?? 0;
    $access = $_POST['access'] ?? 0;

    if (!$name || !$lat || !$lng || !$radius || !$code) {
        echo json_encode(['status' => 'error', 'message' => 'All fields are required']);
        exit;
    }

    $stmt = $connect->prepare("
        INSERT INTO t_locations (name, lat, lng, color, radius, code, active, access) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)
    ");
    $stmt->bind_param("ssssiisi", $name, $lat, $lng, $color, $radius, $code, $active, $access);

    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Location added successfully']);
    } else {
        echo json_encode(['status' => 'error', 'message' => $stmt->error]);
    }

    $stmt->close();
    exit;
}

// Menampilkan semua lokasi
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $stmt = $connect->prepare("
        SELECT 
            id,
            name,
            lat,
            lng,
            color,
            radius,
            code,
            active,
            access,
            created_at,
            updated_at
        FROM t_locations
        WHERE active = 1
    ");

    if (!$stmt) {
        echo json_encode(['status' => 'error', 'message' => $connect->error]);
        exit;
    }

    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $locations = [];
        while ($row = $result->fetch_assoc()) {
            $locations[] = [
                'id' => $row['id'],
                'name' => $row['name'],
                'lat' => (float)$row['lat'],
                'lng' => (float)$row['lng'],
                'color' => $row['color'],
                'radius' => (int)$row['radius'],
                'code' => $row['code'],
                'active' => (bool)$row['active'],
                'access' => (int)$row['access'],
                'created_at' => $row['created_at'],
                'updated_at' => $row['updated_at'],
            ];
        }

        echo json_encode([
            'status' => 'success',
            'message' => 'Locations retrieved successfully',
            'data' => $locations
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'No locations found']);
    }

    $stmt->close();
}

// Tutup koneksi
mysqli_close($connect);
?>