<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
require '../../config_absen.php'; // Pastikan path menuju config file sesuai
header('Content-Type: application/json');

// Periksa apakah metode HTTP adalah POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

// Koneksi ke database
$connect = getDatabaseConnection();

// Ambil data dari POST
$id_pegawai = $_POST['id_pegawai'] ?? null;
$NamaClient = $_POST['NamaClient'] ?? null;
$Tanggal = $_POST['Tanggal'] ?? null;
$NmrFaktur = $_POST['NmrFaktur'] ?? null;
$Karyawan = $_POST['Karyawan'] ?? null;
$Alamat = $_POST['Alamat'] ?? null;

// Validasi input
if (!$id_pegawai || !$NamaClient || !$Tanggal || !$NmrFaktur || !$Karyawan || !$Alamat) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Semua field wajib diisi',
        'received_input' => [
            'id_pegawai' => $id_pegawai ?? 'Tidak diterima',
            'NamaClient' => $NamaClient ?? 'Tidak diterima',
            'Tanggal' => $Tanggal ?? 'Tidak diterima',
            'NmrFaktur' => $NmrFaktur ?? 'Tidak diterima',
            'Karyawan' => $Karyawan ?? 'Tidak diterima',
            'Alamat' => $Alamat ?? 'Tidak diterima',
            'FotoImg' => isset($_FILES['FotoImg']) ? $_FILES['FotoImg']['name'] : 'Tidak diterima',
        ],
    ]);
    exit;
}

// Direktori untuk menyimpan gambar
$upload_dir = '../../AppsMobile/AmbilNota/foto/';
if (!is_dir($upload_dir)) {
    mkdir($upload_dir, 0755, true);
}

// Fungsi untuk mengompresi gambar
function compressImage($source, $destination, $quality) {
    $info = getimagesize($source);

    if ($info['mime'] === 'image/jpeg') {
        $image = imagecreatefromjpeg($source);
    } elseif ($info['mime'] === 'image/png') {
        $image = imagecreatefrompng($source);
        // Konversi PNG ke JPEG untuk pengurangan ukuran
        $background = imagecreatetruecolor(imagesx($image), imagesy($image));
        imagefill($background, 0, 0, imagecolorallocate($background, 255, 255, 255));
        imagealphablending($background, true);
        imagecopy($background, $image, 0, 0, 0, 0, imagesx($image), imagesy($image));
        $image = $background;
    } else {
        return false; // Format tidak didukung
    }

    return imagejpeg($image, $destination, $quality);
}

// Proses upload gambar
$FotoImg = null;
if (isset($_FILES['FotoImg'])) {
    $file_name = time() . '_nota.jpg';
    $file_path = $upload_dir . $file_name;

    // Kompres gambar jika format didukung
    if (!compressImage($_FILES['FotoImg']['tmp_name'], $file_path, 75)) {
        // Jika format tidak didukung, unggah file asli
        if (!move_uploaded_file($_FILES['FotoImg']['tmp_name'], $file_path)) {
            echo json_encode(['status' => 'error', 'message' => 'Gagal mengunggah file gambar asli']);
            exit;
        }
    }

    $FotoImg = $file_name; // Simpan nama file ke database
}

// Cek apakah nomor faktur sudah ada
$query_check = "SELECT * FROM KunjunganGudang WHERE NmrFaktur = ?";
$stmt_check = $connect->prepare($query_check);
$stmt_check->bind_param("s", $NmrFaktur);
$stmt_check->execute();
$result_check = $stmt_check->get_result();

if ($result_check->num_rows > 0) {
    echo json_encode(['status' => 'error', 'message' => 'Nomor faktur sudah ada']);
} else {
    // Insert data baru
    $query_insert = "INSERT INTO KunjunganGudang (id_pegawai, NamaClient, Tanggal, NmrFaktur, FotoImg, Karyawan, Alamat) 
                     VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt_insert = $connect->prepare($query_insert);
    $stmt_insert->bind_param("issssss", $id_pegawai, $NamaClient, $Tanggal, $NmrFaktur, $FotoImg, $Karyawan, $Alamat);

    if ($stmt_insert->execute()) {
        // Respons data yang berhasil dimasukkan
        echo json_encode([
            'status' => 'success',
            'message' => 'Nota berhasil terkirim',
            'data' => [
                'NamaClient' => $NamaClient,
                'Tanggal' => $Tanggal,
                'NmrFaktur' => $NmrFaktur,
                'FotoImg' => $FotoImg,
                'Karyawan' => $Karyawan,
                'Alamat' => $Alamat,
            ],
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Gagal mengirim data nota']);
    }

    $stmt_insert->close();
}

// Tutup koneksi
$stmt_check->close();
mysqli_close($connect);
?>