<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
header('Content-Type: application/json');
$hostname   = "localhost";
$user       = "groupber_gaji";
$password   = "group_gaji24";
$database   = "groupber_payroll";

$connect = mysqli_connect($hostname, $user, $password, $database);
if (!$connect) {
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
$id_penggajian = $data['id_penggajian'] ?? null;
$status_gaji = $data['status_gaji'] ?? null;

if (!$id_penggajian || !$status_gaji) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid parameters']);
    exit;
}

$query = "UPDATE t_pembayaran_gaji SET status_gaji = ? WHERE id_penggajian = ?";
$stmt = $connect->prepare($query);
$stmt->bind_param("ss", $status_gaji, $id_penggajian);

if ($stmt->execute()) {
    echo json_encode(['status' => 'success', 'message' => 'Status gaji berhasil diubah']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Gagal mengubah status gaji']);
}

$stmt->close();
mysqli_close($connect);
?>